@echo off
rem ESET Security Management Center
rem Copyright (c) 1992-2018 ESET, spol. s r.o. All Rights Reserved

call :install_agent
goto :eof

rem __Function install_agent___
:install_agent
setlocal EnableDelayedExpansion

set server_hostname=ESET.wodgm0dn2keuzfjgwcsrqlfvpb.zx.internal.cloudapp.net
set server_port=2222
set peer_cert_b64=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
set peer_cert_pwd=MG1zYWNyZTNuRDEyMyE=
set ca_cert_b64=MIID3zCCAsegAwIBAgIQebK0Ra6E37BAptqaP2bOxjANBgkqhkiG9w0BAQUFADCBhzEnMCUGA1UEAxMeU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MScwJQYDVQQKEx5PeGZvcmQgTWFjaW50b3NoIFNvbHV0aW9ucyBMdGQxEDAOBgNVBAcTB0V5bnNoYW0xFDASBgNVBAgTC094Zm9yZHNoaXJlMQswCQYDVQQGEwJHQjAeFw0xNTA5MTIwMDAwMDBaFw0yNTA5MTMwMDAwMDBaMIGHMScwJQYDVQQDEx5TZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxJzAlBgNVBAoTHk94Zm9yZCBNYWNpbnRvc2ggU29sdXRpb25zIEx0ZDEQMA4GA1UEBxMHRXluc2hhbTEUMBIGA1UECBMLT3hmb3Jkc2hpcmUxCzAJBgNVBAYTAkdCMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtXahEu/AP1koaXsw2pj+yTpdAtJAC3CsbGHa99Inzk4Tjk6MfcHXXeRQ7jrNac2g8y62zt1xrqlumouFbsikwPDBkbNNpQQRnX6aR4qldmCZhlSBCEDgB8ZrvU74LFcl36ZpGEaHMe76EwHauVip3iPDry5CZ0yG4LEFo/YCQVQftXs4/oglK/t8+dt5F4pEQb2fn7T0o0pZ0My0JCHcQ9x9tcY6DxJBYc9MJcznmg1+9T4ihIwhWh/veszBaWVFbCOrnK1Xg1aEYNBgKqHfCtRdrWSzHyGDJMZkrKVX2KwjRcAEGPmLYjkJagGGjHkUwgZ/LbZX40ebvzgfdZFmVwIDAQABo0UwQzAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUl6MJ7or8QQNoH/xWy+axIbINB3swDQYJKoZIhvcNAQEFBQADggEBAKeSuSvk/2mgcFk9SknXCQTntUtbR0J0uLRZOe+OqJUnZxmlAwGYhhKW+dq+89+HuLiPCHa1zsU3Cxwb5UeFxpHFGSzCdIITSgcasCVpDs42mRm0J6UlhDARuzFL9U31qYVkQF3jgKE7tDCeipe2Uum3aopML39sR+F/0lhWfBvmbuxfQOE4Ug6C+/qxMGFfmxm7n7ppRywb8BWT/mCFbF9D9c28RhO0rrObvjP+POViLLs6Nl+xlW2wXVpX4v60c1aqJgZDv5Z148X5g1DO1t2IqkQvmCAsDzvbp2E1y48p6E82WVcWan0pNw8lTyXAC3kUn62HYEXCQD4hcCOgFX8=
set product_uuid=
set initial_sg_token=

set http_proxy_hostname=
set http_proxy_port=
set http_proxy_username=
set http_proxy_password=
set enable_telemetry=1

if "%PROCESSOR_ARCHITECTURE%" == "x86" (
  if not defined PROCESSOR_ARCHITEW6432 set IsArch_x86=true
)

set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v7/7.0.577.0/agent_x64.msi
set checksum=4c2737fc96465e56381620156254b8daec097ef4
if defined IsArch_x86 (
  set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v7/7.0.577.0/agent_x86.msi
  set checksum=4f9052a7438a67e7e3cf9c7766bcf187b16eb590
)

set ca_path=%temp%\era.ca.der.b64
if exist !ca_path! del !ca_path!
> !ca_path! echo !ca_cert_b64!

set peer_cert_path=%temp%\era.peer.pfx.b64
if exist !peer_cert_path! del !peer_cert_path!
> !peer_cert_path! echo !peer_cert_b64!

for /f "tokens=2 delims=[]" %%G in ('ver') Do (set os_version=%%G)

for /f "tokens=2,3,4 delims=. " %%G in ('echo %os_version%') Do (set os_version_major=%%G& set os_version_minor=%%H& set os_version_build=%%I)

echo Installing ESET Management Agent...

> "%temp%\uacinstall.vbs" (
echo.' ESET Security Management Center
echo.' Copyright ^(c^) 1992-2018 ESET, spol. s r.o. All Rights Reserved
echo.
echo.Class CComputer
echo.    Private m_MACAddress
echo.    Private m_Parameters
echo.    Public Function Init^(MACAddress, Parameters^)
echo.        m_MACAddress = MACAddress
echo.        m_Parameters = Parameters
echo.        Set Init = Me
echo.    End Function
echo.    Public Property Get MACAddress
echo.        MACAddress = m_MACAddress
echo.    End Property
echo.    Public Property Get Parameters
echo.        Parameters = m_Parameters
echo.    End Property
echo.End Class
echo.
echo.Dim computers: computers = Array^( _

echo.^)
echo.
echo.On Error Resume Next
echo.packageLocation = DownloadUsingHTTPProxy^("!url!", "!http_proxy_hostname!", "!http_proxy_port!", "!http_proxy_username!", "!http_proxy_password!"^)
echo.If packageLocation = "" Then
echo.    packageLocation = DownloadUsingHTTPProxy^("!url!", "", "", "", ""^)
echo.    If packageLocation = "" Then
echo.        Wscript.Quit 30
echo.    End If
echo.End If
echo.On Error GoTo 0
echo.
echo.
echo.Dim ca_b64: ca_b64 = "!ca_cert_b64!"
echo.Dim product_uuid: product_uuid = "!product_uuid!"
echo.
echo.Function GetCollectionCount^(collection^)
echo.    GetCollectionCount = 0
echo.    On Error Resume Next
echo.    GetCollectionCount = collection.Count
echo.End Function
echo.
echo.Dim params: params = "/qr /i """ ^& packageLocation ^& """ /l*v ""%temp%\ra-agent-install.log""" ^&_
echo.                     " ALLUSERS=1 REBOOT=ReallySuppress" ^&_
echo.                     " P_CONNECTION_CHOSEN=Host" ^&_
echo.                     " P_HOSTNAME=""!server_hostname!""" ^&_
echo.                     " P_PORT=""!server_port!""" ^&_
echo.                     " P_CERT_PATH=""!peer_cert_path!""" ^&_
echo.                     " P_CERT_PASSWORD=""!peer_cert_pwd!""" ^&_
echo.                     " P_CERT_PASSWORD_IS_BASE64=YES" ^&_
echo.                     " P_INITIAL_STATIC_GROUP=""!initial_sg_token!""" ^&_
echo.                     " P_ENABLE_TELEMETRY=""!enable_telemetry!""" ^&_
echo.                     " P_LOAD_CERTS_FROM_FILE_AS_BASE64=YES"
echo.
echo.If ca_b64 ^<^> "" Then
echo.    params = params ^& " P_CERT_AUTH_PATH=""!ca_path!"""
echo.End If
echo.
echo.If product_uuid ^<^> "" Then
echo.    params = params ^& " P_CMD_PRODUCT_GUID=""!product_uuid!"""
echo.End If
echo.
echo.If UBound^(computers^) ^>= 0 Then
echo.    Dim wmi: Set wmi = GetObject^("winmgmts:\\.\root\cimv2"^)
echo.    Dim networkAdapters: Set networkAdapters = wmi.ExecQuery^("SELECT * FROM Win32_NetworkAdapter"^)
echo.    Dim networkAdapter
echo.    Dim macFound: macFound = false
echo.
echo.    If GetCollectionCount^(networkAdapters^) ^<^> 0 Then
echo.        For Each networkAdapter In networkAdapters
echo.            If Not isnull^(networkAdapter.MACAddress^) Then
echo.                Dim MACAddress: MACAddress = UCase^(replace^(networkAdapter.MACAddress, ":", ""^)^)
echo.                For Each computer In computers
echo.                    If computer.MACAddress = MACAddress Then
echo.                        params = params ^& " " ^& computer.Parameters
echo.                        macFound = true
echo.                        Exit For
echo.                    End If
echo.                Next
echo.            End If
echo.            If macFound Then
echo.                Exit For
echo.            End If
echo.         Next
echo.    End If
echo.End If
echo.
echo.Function DownloadUsingHTTPProxy^(strLink, strProxyHostname, strProxyPort, strProxyUser, strProxyPassword^)
echo.    Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo.    strSaveName = Mid^(strLink, InStrRev^(strLink,"/"^) + 1, Len^(strLink^)^)
echo.    strSaveTo = objFSO.GetSpecialFolder^(2^) ^& "\" ^& strSaveName
echo.
echo.    Set objHTTP = CreateObject^("WinHttp.WinHttpRequest.5.1"^)
echo.    objHTTP.Open "GET", strLink, False
echo.    If Len^(strProxyHostname^) ^> 0 Then
echo.        objHttp.SetProxy 2, strProxyHostname ^& ":" ^& strProxyPort
echo.        If Len^(strProxyUser^) ^> 0 Then
echo.            const HTTPREQUEST_SETCREDENTIALS_FOR_PROXY = 1
echo.            objHTTP.SetCredentials strProxyUser, strProxyPassword, HTTPREQUEST_SETCREDENTIALS_FOR_PROXY
echo.        End If
echo.    End If
echo.    objHTTP.Send
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        objFSO.DeleteFile^(strSaveTo^)
echo.    End If
echo.
echo.    If objHTTP.Status = 200 Then
echo.        Dim objStream
echo.        Set objStream = CreateObject^("ADODB.Stream"^)
echo.        With objStream
echo.            .Type = 1 'adTypeBinary
echo.            .Open
echo.            .Write objHTTP.ResponseBody
echo.            .SaveToFile strSaveTo
echo.            .Close
echo.        End With
echo.        Set objStream = Nothing
echo.    End If
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        DownloadUsingHTTPProxy = strSaveTo
echo.    End If
echo.End Function
echo.
echo.Function DropSHA1Tool^(^)
echo.    Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo.    strSaveName = "sha1sum.exe"
echo.    strSaveTo = objFSO.GetSpecialFolder^(2^) ^& "\" ^& strSaveName
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        objFSO.DeleteFile^(strSaveTo^)
echo.    End If
echo.
echo.    Set oXML = CreateObject^("Msxml2.DOMDocument.3.0"^)
echo.    Set oNode = oXML.CreateElement^("base64"^)
echo.    oNode.dataType = "bin.base64"
echo.    oNode.text =               "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "rwkAAIlF5OjUFwAAA8NQV+gcGgAAg8QYx0X8/v///+gJAAAAi0Xk6IkaAADD6K4XAACDwCBQagHoKRkAAFlZw6EE8EAAg8gBM8k5BcD+QAAPlMGLwcNqDGiw20AA6A4aAAAz24ld5DPAi30IO/sPlcA7w3UU6B0XAADHABYAAADowBYAADPA63kzwIt1DDvzD5XAO8N03jPAOB4PlcA7w3TT6E8eAACJRQg7w3UN6OQWAADHABgAAADryold/DgfdSDo0BYAAMcAFgAAAGr+jUXwUGgE8EAA6FMfAACDxAzro1D/dRBWV+hyGwAAg8QQiUXkx0X8/v///+gJAAAAi0Xk6K4ZAADD/3UI6BoYAABZw4v/VYvsakD/dQz/dQjoMv///4PEDF3Di/9Vi+yD7BCLTQhTi10MVleLfRCJTfiJXfyF/3Qag30UAHQUhcl1F+hBFgAAxwAWAAAA6OQVAAAzwF9eW8nDi3UYhfZ0DIPI/zPS9/c5RRR2IYP7/3QMU2oAUehnKAAAg8QMhfZ0wYPI/zPS9/c5RRR3tQ+vfRT3RgwMAQAAiX3wi990CItGGIlF9OsHx0X0ABAAAIX/D4TaAAAA90YMDAEAAHREi0YEhcB0PQ+I8gAAAIv7O9hyAov4O338D4e7AAAAV/82/3X8/3X46H0nAAApfgQBPgF9+Cvfg8QQKX38i33w6YUAAAA7XfRyXIN99AB0H7n///9/M9I72XYJi8H3dfSLwesHi8P3dfSLwyvC6wu4////fzvYdwKLwztF/HdbUP91+Fbo+yYAAFlQ6P4lAACDxAyFwHR7g/j/dGQBRfgr2ClF/OskVugJHwAAWYP4/3RSg338AHQii034/0X4iAGLRhhL/038iUX0hdsPhSb///+LRRTpvP7//4N9DP90EP91DGoA/3UI6DYnAACDxAzo1RQAAMcAIgAAAOmP/v//g04MIIvHK8Mz0vd1EOmE/v//g04MEOvsagxo0NtAAOh/FwAAM/aJdeQ5dRB0Lzl1FHQqOXUYdS2DfQz/dA//dQxW/3UI6NkmAACDxAzoeBQAAMcAFgAAAOgbFAAAM8DohBcAAMP/dRjofRUAAFmJdfz/dRj/dRT/dRD/dQz/dQjo1/3//4PEFIlF5MdF/P7////oBQAAAItF5OvD/3UY6LkVAABZw4v/VYvs/3UU/3UQ/3UMav//dQjoWv///4PEFF3Di/9Vi+yLRQiFwHUU6PYTAADHABYAAADomRMAADPAXcOLQAyD4CBdw4v/VYvsVot1CFeDz/+F9nUU6MkTAADHABYAAADobBMAAAvH60T2RgyDdDhW6EwoAABWi/joEygAAFboWiUAAFDoQycAAIPEEIXAeQWDz//rEotGHIXAdAtQ6FQmAACDZhwAWYNmDACLx19eXcNqDGjw20AA6D8WAACDTeT/M8CLdQiF9g+VwIXAdRXoTxMAAMcAFgAAAOjyEgAAg8j/6w32RgxAdA2DZgwAi0Xk6EsWAADDVuhGFAAAWYNl/ABW6Dz///9ZiUXkx0X8/v///+gFAAAA69SLdQhW6JMUAABZw4v/VYvsgz3M/kAAAnQF6CwuAAD/dQjodSwAAGj/AAAA6IUpAABZWV3DahRoENxAAOiiFQAAM/Y5NYgcQQB1C1ZWagFW/xUEwEAAuE1aAABmOQUAAEAAdAWJdeTrNqE8AEAAgbgAAEAAUEUAAHXquQsBAABmOYgYAEAAddyDuHQAQAAOdtMzyTmw6ABAAA+VwYlN5Oj3OQAAhcB1CGoc6F3///9Z6Gs4AACFwHUIahDoTP///1noFTUAAIl1/OjIMgAAhcB5CGob6H8rAABZ/xUAwEAAo4QcQQDoFTIAAKPE/kAA6FAxAACFwHkIagjoWSsAAFnoyS4AAIXAeQhqCehIKwAAWWoB6B8pAABZO8Z0B1DoNSsAAFmhFAJBAKMYAkEAUP81DAJBAP81CAJBAOhs9///g8QMiUXgOXXkdQZQ6L0qAADo5CoAAOsui0XsiwiLCYlN3FBR6BstAABZWcOLZeiLRdyJReCDfeQAdQZQ6KMqAADowyoAAMdF/P7///+LReDokxQAAMPoHjkAAOmV/v//i/9Vi+yB7CgDAACj2P9AAIkN1P9AAIkV0P9AAIkdzP9AAIk1yP9AAIk9xP9AAGaMFfD/QABmjA3k/0AAZowdwP9AAGaMBbz/QABmjCW4/0AAZowttP9AAJyPBej/QACLRQCj3P9AAItFBKPg/0AAjUUIo+z/QACLheD8///HBSj/QAABAAEAoeD/QACj3P5AAMcF0P5AAAkEAMDHBdT+QAABAAAAoQTwQACJhdj8//+hCPBAAImF3Pz///8VGMBAAKMg/0AAagHo5zgAAFlqAP8VFMBAAGhswUAA/xUQwEAAgz0g/0AAAHUIagHowzgAAFloCQQAwP8VDMBAAFD/FQjAQADJw4v/VYvsUVaLdQxW6A4iAACJRQyLRgxZqIJ1F+hEEAAAxwAJAAAAg04MIIPI/+kvAQAAqEB0DegpEAAAxwAiAAAA6+NTM9uoAXQWiV4EqBAPhIcAAACLTgiD4P6JDolGDItGDIPg74PIAolGDIleBIld/KkMAQAAdSzoLxAAAIPAIDvwdAzoIxAAAIPAQDvwdQ3/dQzopkEAAFmFwHUHVuhSQQAAWfdGDAgBAABXD4SAAAAAi0YIiz6NSAGJDotOGCv4SYlOBDv7fh1XUP91DOhOQAAAg8QMiUX8602DyCCJRgyDyP/reYtNDIP5/3Qbg/n+dBaLwYPgH4vRwfoFweAGAwSVYAtBAOsFuBD1QAD2QAQgdBRqAlNTUegcOAAAI8KDxBCD+P90JYtGCIpNCIgI6xYz/0dXjUUIUP91DOjfPwAAg8QMiUX8OX38dAmDTgwgg8j/6wiLRQgl/wAAAF9bXsnDi/9Vi+yLRQhWi/HGRgwAhcB1Y+i1MwAAiUYIi0hsiQ6LSGiJTgSLDjsNwPxAAHQSiw14+kAAhUhwdQfolkoAAIkGi0YEOwWA+UAAdBaLRgiLDXj6QACFSHB1COj1QgAAiUYEi0YI9kBwAnUUg0hwAsZGDAHrCosIiQ6LQASJRgSLxl5dwgQA9kEMQHQGg3kIAHQk/0kEeAuLEYgC/wEPtsDrDA++wFFQ6O/9//9ZWYP4/3UDCQbD/wbDi/9Vi+xR9kMMQFaL8IsHiUX8dA2DewgAdQeLRQwBBus+gycAg30MAH4wi0UIigD/TQyLy+iU/////0UIgz7/dQ6DPyp1D4vLsD/ofv///4N9DAB/1YM/AHUFi0X8iQdeycOL/1WL7IHsgAIAAKEE8EAAM8WJRfxTi10MVot1CDPAV4t9FP91EI2NpP3//4m10P3//4m95P3//4mFtP3//4mF8P3//4mFyP3//4mF6P3//4mFzP3//4mFvP3//4mFxP3//+h9/v//6HgNAACJhZT9//+F9nUr6GkNAADHABYAAADoDA0AAIC9sP3//wB0CouFrP3//4NgcP2DyP/pNwsAAPZGDEB1Xlbo8R4AAFm6EPVAAIP4/3Qbg/j+dBaLyIPhH4vwwf4FweEGAwy1YAtBAOsCi8r2QSR/dZuD+P90GYP4/nQUi8iD4B/B+QXB4AYDBI1gC0EA6wKLwvZAJIAPhXH///8zyTvZD4Rn////ihOJjdz9//+Jjdj9//+Jjbj9//+Ile/9//+E0g+EjgoAAEMz9omdwP3//zm13P3//w+MeQoAAI1C4DxYdw8PvsIPvoBwwUAAg+AP6wIzwA++hMGQwUAAagfB+ARZiYWM/f//O8EPhyAKAAD/JIWbOUAAg43o/f///4m1iP3//4m1vP3//4m1yP3//4m1zP3//4m18P3//4m1xP3//+npCQAAD77Cg+ggdEqD6AN0NoPoCHQlSEh0FYPoAw+FygkAAION8P3//wjpvgkAAION8P3//wTpsgkAAION8P3//wHppgkAAIGN8P3//4AAAADplwkAAION8P3//wLpiwkAAID6KnUsg8cEib3k/f//i3/8ib3I/f//O/4PjWwJAACDjfD9//8E953I/f//6VoJAACLhcj9//9rwAoPvsqN"
echo.    oNode.text = oNode.text ^& "RAjQiYXI/f//6T8JAACJtej9///pNAkAAID6KnUmg8cEib3k/f//i3/8ib3o/f//O/4PjRUJAACDjej9////6QkJAACLhej9//9rwAoPvsqNRAjQiYXo/f//6e4IAACA+kl0VYD6aHREgPpsdBiA+ncPhdYIAACBjfD9//8ACAAA6ccIAACAO2x1FkOBjfD9//8AEAAAiZ3A/f//6awIAACDjfD9//8Q6aAIAACDjfD9//8g6ZQIAACKAzw2dR6AewE0dRiDwwKBjfD9//8AgAAAiZ3A/f//6XAIAAA8M3UegHsBMnUYg8MCgaXw/f///3///4mdwP3//+lOCAAAPGQPhEYIAAA8aQ+EPggAADxvD4Q2CAAAPHUPhC4IAAA8eA+EJggAADxYD4QeCAAAibWM/f//IbXE/f//jYWk/f//UA+2wlDookkAAFmFwIqF7/3//1l0IouN0P3//4213P3//+i2+///igNDiZ3A/f//hMAPhLD8//+LjdD9//+Ntdz9///olPv//+m+BwAAD77Cg/hkD4+2AQAAD4RYAgAAg/hTD4+6AAAAdEyD6EF0EEhIdCRISHQISEgPhasFAACAwiDHhYj9//8BAAAAiJXv/f//6VYCAAD3hfD9//8wCAAAD4WeAAAAgY3w/f//AAgAAOmPAAAA94Xw/f//MAgAAHUKgY3w/f//AAgAAIuN6P3//4P5/3UFuf///3+DxwT3hfD9//8QCAAAib3k/f//i3/8ib3g/f//D4T+BAAAhf91C6EQ8EAAiYXg/f//i4Xg/f//x4XE/f//AQAAAOnMBAAAg+hYD4QiAwAASEh0fyvBD4S2AQAASEgPhesEAACLveT9//+DxwT3hfD9//8QCAAAib3k/f//dDAPt0f8UGgAAgAAjYX0/f//UI2F2P3//1DoF0gAAIPEEIXAdB/Hhbz9//8BAAAA6xOKR/yIhfT9///Hhdj9//8BAAAAjYX0/f//iYXg/f//6XwEAACLB4PHBIm95P3//4XAdDuLSASFyXQ094Xw/f//AAgAAA+/AImN4P3//3QUmSvC0fjHhcT9//8BAAAA6TcEAAAhtcT9///pLAQAAKEM8EAAiYXg/f//UOilRQAAWekVBAAAg/hwD489AgAAD4QlAgAAg/hlD4wDBAAAg/hnD463AAAAg/hpdHyD+G50LoP4bw+F5wMAAPaF8P3//4CLveT9///Hhdj9//8IAAAAdGyBjfD9//8AAgAA62CDheT9//8Ei4Xk/f//i3D86IHw//+FwA+EYvr///aF8P3//yB0DGaLhdz9//9miQbrCIuF3P3//4kGx4W8/f//AQAAAOk+BQAAi73k/f//g43w/f//QMeF2P3//woAAACLjfD9///3wQCAAAAPhOABAACLB4tXBIPHCOkMAgAAi73k/f//g43w/f//QI2d9P3//7gAAgAAiZ3g/f//iYWg/f//ObXo/f//fQzHhej9//8GAAAA62p1EYD6Z3Vjx4Xo/f//AQAAAOtXOYXo/f//fgaJhej9//+Bvej9//+jAAAAfj2Ltej9//+Bxl0BAABW6GlDAACKle/9//9ZiYW4/f//hcB0EImF4P3//4m1oP3//4vY6wrHhej9//+jAAAAiweLNRzAQACDxwiJhYD9//+LR/yJhYT9//+NhaT9//9Q/7WI/f//D77C/7Xo/f//ib3k/f//UP+1oP3//42FgP3//1NQ/zXc/EAA/9b/0Iu98P3//4PEHIHngAAAAHQdg73o/f//AHUUjYWk/f//UFP/Nej8QAD/1v/QWVmAve/9//9ndRiF/3UUjYWk/f//UFP/NeT8QAD/1v/QWVmAOy11EYGN8P3//wABAABDiZ3g/f//U+nB/f//x4Xo/f//CAAAAImNtP3//+sqg+hzD4Ru/P//SEgPhFj+//+D6AMPhbsBAACLveT9///HhbT9//8nAAAA9oXw/f//gMeF2P3//xAAAAAPhDL+//+KhbT9//8EUcaF1P3//zCIhdX9///Hhcz9//8CAAAA6Q7+///3wQAQAAAPhRT+//+DxwT2wSB0GIm95P3///bBQHQGD79H/OsED7dH/JnrE4tH/PbBQHQDmesCM9KJveT9///2wUB0GoXSfxZ8BIXAcxD32BPW99qBjfD9//8AAQAA94Xw/f//AJAAAIv6i9h1AjP/ObXo/f//fQzHhej9//8BAAAA6xqDpfD9///3uAACAAA5hej9//9+BomF6P3//4vDC8d1BiG1zP3//41184uF6P3///+N6P3//4XAfwaLwwvHdC2Lhdj9//+ZUlBXU+hxRAAAg8EwiZ2g/f//i9iL+oP5OX4GA420/f//iA5O672NRfMrxkb3hfD9//8AAgAAiYXY/f//ibXg/f//dGKFwHQHi86AOTB0V/+N4P3//4uN4P3//8YBMEDrP0lmOTB0B4PAAoXJdfMrheD9///R+Osohf91C6EM8EAAiYXg/f//i4Xg/f//6wdJgDgAdAVAhcl19SuF4P3//4mF2P3//4O9vP3//wAPhbgBAACLjfD9///2wUB0NffBAAEAAHQJxoXU/f//Lesa9sEBdAnGhdT9//8r6wz2wQJ0EcaF1P3//yDHhcz9//8BAAAAi4XI/f//K4XY/f//K4XM/f//iYWg/f//9sEMdSWL+Osdi43Q/f//jbXc/f//sCBP6DD1//+Dvdz9////dASF/3/f/7XM/f//i72U/f//i53Q/f//jYXU/f//UI2F3P3//+gy9f//9oXw/f//CFlZdC72hfD9//8EdSWLvaD9///rGY213P3//4vLsDBP6NP0//+Dvdz9////dASF/3/jg73E/f//AIuF2P3//3R1hcB+cYu14P3//4mFmP3//w+3Bv+NmP3//1BqBo1F9FCNhZD9//9Qg8YC6DpCAACDxBCFwHU2OYWQ/f//dC7/tZD9//+LvZT9//+LndD9//+NRfRQjYXc/f//6Iv0//+DvZj9//8AWVl1pusjg43c/f///+sai72U/f//UP+14P3//42F3P3//+hd9P//WVmDvdz9//8AfDL2hfD9//8EdCmLvaD9///rHYuN0P3//4213P3//7AgT+j68///g73c/f///3QEhf9/34O9uP3//wB0E/+1uP3//+glFQAAg6W4/f//AFmLncD9//+KA4iF7/3//4TAdBOLjYz9//+LveT9//+K0Oly9f//gL2w/f//AHQKi4Ws/f//g2Bw/YuF3P3//4tN/F9eM81b6G7p///Jw5A1MUAANC9AAGQvQADCL0AADjBAABkwQABfMEAAjzFAAIv/VYvsi0UIo/QBQQBdw4v/VYvsgewoAwAAoQTwQAAzxYlF/FOLXQhXg/v/dAdT6PIpAABZg6Xg/P//AGpMjYXk/P//agBQ6OkTAACNheD8//+Jhdj8//+NhTD9//+DxAyJhdz8//+JheD9//+Jjdz9//+Jldj9//+JndT9//+JtdD9//+Jvcz9//9mjJX4/f//ZoyN7P3//2aMncj9//9mjIXE/f//ZoylwP3//2aMrbz9//+cj4Xw/f//i0UEjU0EiY30/f//x4Uw/f//AQABAImF6P3//4tJ/ImN5P3//4tNDImN4Pz//4tNEImN5Pz//4mF7Pz///8VGMBAAGoAi/j/FRTAQACNhdj8//9Q/xUQwEAAhcB1EIX/dQyD+/90B1Po/SgAAFmLTfxfM81b6BXo///Jw4v/VmoBvhcEAMBWagLoxf7//4PEDFb/FQzAQABQ/xUIwEAAXsOL/1WL7P819AFBAP8VHMBAAIXAdANd/+D/dRj/dRT/dRD/dQz/dQjor////8wzwFBQUFBQ6Mf///+DxBTDi/9Vi+yLRQgzyTsEzRjwQAB0E0GD+S1y8Y1I7YP5EXcOag1YXcOLBM0c8EAAXcMFRP///2oOWTvIG8AjwYPACF3D6E8kAACFwHUGuIDxQADDg8AIw+g8JAAAhcB1BriE8UAAw4PADMOL/1WL7Fbo4v///4tNCFGJCOiC////WYvw6Lz///+JMF5dw7iI8UAAw6GAHEEAVmoUXoXAdQe4AAIAAOsGO8Z9B4vG"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAeAAAAAgIAMIIeBAYJKoZIhvcNAQcCoIId9TCCHfECAQExCzAJBgUrDgMCGgUAMEwGCisGAQQBgjcCAQSgPjA8MBcGCisGAQQBgjcCAQ8wCQMBAKAEogKAADAhMAkGBSsOAwIaBQAEFHqDbswXC3GhuCdlKUxmZP1gtCrAoIIZPDCCA+4wggNXoAMCAQICEH6T6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1waW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIzNTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qka81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1FhAlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK+/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xniRAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGjgfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xMgC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYWaHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBpbmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEBBQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZSnxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGbsBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBiJZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZg362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsaUDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0yMDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UEAxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNlcyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOTsJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyGduXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJvTlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbbYTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZvSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEtnndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjhEChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcwAYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6QdMBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYDVR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1UdIwQYMBaAFF+a9W5czMx0mtTdfe8/"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    binaryData = oNode.nodeTypedValue
echo.    Set oNode = Nothing
echo.    Set oXML = Nothing
echo.
echo.    Dim objStream
echo.    Set objStream = CreateObject^("ADODB.Stream"^)
echo.    With objStream
echo.        .Type = 1 'adTypeBinary
echo.        .Open
echo.        .Write binaryData
echo.        .SaveToFile strSaveTo
echo.        .Close
echo.    End With
echo.    Set objStream = Nothing
echo.    DropSHA1Tool = strSaveTo
echo.End Function
echo.
echo.' Drop ESET SHA1 Checksum Support Tool used to verify integrity of downloaded installer file
echo.sha1sum = DropSHA1Tool^(^)
echo.
echo.command = sha1sum ^& " " ^& packageLocation ^& " " ^& "!checksum!"
echo.
echo.Set WshShell = CreateObject^("WScript.Shell"^)
echo.exitCode     = WshShell.Run^(command, 0, True^)
echo.
echo.If exitCode ^<^> 0 Then
echo.    Wscript.Quit exitCode
echo.End If
echo.
echo.Set UAC = CreateObject^("Shell.Application"^)
echo.
echo.If !os_version_major! ^> 5 Then
echo.    UAC.ShellExecute "msiexec.exe", params, "", "runas", 1
echo.Else
echo.    UAC.ShellExecute "msiexec.exe", params, "", "open", 1
echo.End If
)

"%temp%\uacinstall.vbs"
set inst_ret_code=%errorlevel%

if NOT ["%inst_ret_code%"]==["0"] (
    echo Installation failed with error code %inst_ret_code%
    del "%temp%\uacinstall.vbs"
    exit /b %inst_ret_code%
)

del "%temp%\uacinstall.vbs"

endlocal
goto :eof
